import { Component, OnInit , ViewEncapsulation , OnDestroy } from '@angular/core';
import { Router , ActivatedRoute} from '@angular/router';
import { FormBuilder, Validators, FormGroup, FormControl, NgForm } from '@angular/forms';
import { ToastrService } from 'ngx-toastr';

import { PozitifcubeHttpService } from '../../../shared/services/pozitifcube-http.service';

@Component({
  selector: 'app-district-form',
  templateUrl: './district-form.component.html',
  styleUrls: ['./district-form.component.scss'],
  encapsulation: ViewEncapsulation.None
})


export class DistrictFormComponent implements OnInit , OnDestroy {

  public userForm: FormGroup;
  public sidebaron: any;
  public errorMessage: any;
  public pocuErrorHandlers : {};
  public listsubscribes :any;
  countryOptions:any = [];
  cityOptions:any = [];
  areaOptions:any = [];
  
  formid : any;
  companyModel = null;
  statusModel = 0;
  activeLanguages : any[];
  countryModel = null;
  cityModel = null;
  cityWait = false;

  statusOptions:any = [{i:0,n:'Yeni'},{i:1,n:'Aktif'},{i:2,n:'Pasif'}];

  constructor( public aroute : ActivatedRoute , private fb: FormBuilder, private router: Router, private toastr:ToastrService , private pocu:PozitifcubeHttpService) {

    this.pocuErrorHandlers = {       
      sorting: new FormControl('0', Validators.required),
      countryid: new FormControl('0', Validators.required),
      zoneid: new FormControl('0', Validators.required),
      areaid: new FormControl(''),
      navlat: new FormControl(''),
      navlng: new FormControl(''),
      status :  new FormControl('', Validators.required)
    };

    this.activeLanguages = pocu.activeLanguages;
    
    this.pocu.activeLanguages.forEach(lang => {
      this.pocuErrorHandlers[ 'districtname_'+lang.cd ] = new FormControl('', Validators.required);
    })
    
    this.userForm = this.fb.group(this.pocuErrorHandlers);

    this.pocu.getJSONResult('countryList' , 0).subscribe(data => {
      this.countryOptions = data;
    });

    this.pocu.getJSONResult('areaList' , 0).subscribe(data => {
      this.areaOptions = data;
    });

  }

  ngOnDestroy(){
    if(this.formid !== 'new') this.listsubscribes.unsubscribe();
  }

  ngOnInit() { 

    this.aroute.paramMap.subscribe(params => { 
      this.formid = params.get('id');
      if(this.formid !== 'new'){
        this.listsubscribes = this.pocu.getItem(this.formid).subscribe(data => {
          console.log(data);
          const values = {};
          for(let k in this.pocuErrorHandlers){
            values[k] = (data[k] > 0 || data[k]!='' || data[k] instanceof Object) ? data[k] : (k=='identitycheck' || k=='sorting' || k=='status' ? 0:'');
          }
          this.userForm.patchValue(values);
          this.onCountrySelected(0);
        });
      }
    }); 
    
  }

  onCountrySelected(isreset){
    this.cityOptions = [];
    if(isreset==1) this.cityModel = null;
    if(this.countryModel > 0){
      this.cityWait = true;
      this.pocu.getJSONResult('cityList' , this.countryModel ).subscribe(data => {        
        this.cityWait = false; this.cityOptions = data;
      });
    }
  }
  

  submit(value) {

    if (this.userForm.invalid) { return; }
    else{

      if(this.formid == 'new'){
        this.pocu.createItem( value ).subscribe((response) => {
          if(response['result'] == 'OK'){
            this.toastr.success( 'Eklendi' );
            this.router.navigate(['/param/districts']);
          }else{
            this.toastr.warning( 'Bir sorun oluştu' );
            console.log(response);
          }
        }); 
      }else{
        this.pocu.editItem( value , this.formid ).subscribe((response) => {
          if(response['result'] == 'OK'){
            this.toastr.success( 'Düzenlendi' );
            this.router.navigate(['/param/districts']);
          }else{
            this.toastr.warning( 'Bir sorun oluştu' );
            console.log(response);
          }
        });
      }
    }
  }

  cancel() {
    this.router.navigate(['/param/districts']);
  }

}
